<?xml version="1.0"?>
<!-- CSS Generation from skin 
  DEPENDANCES:  Call are made to Batik sub sitemap for SVG-JPEG generation
                Referring to class and id defined in generated CSS are made by :
                 [Header, Navgen, Tools, Doc][2html] XSL files.
    Content structure : 
        A. STRUCTURAL PROCESSING
        1. header
        2. navbar
        3. navpan
        4. doc
        5. tools
        B. GENERIC PROCESSING
        1. gensvg
        2. framesvg
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:param name="skinname" select="'skin-1N'"/>    
<xsl:variable name="tile-width" select="15"/>
<xsl:variable name="tile-height" select="15"/>
<xsl:variable name="pattern-width" select="150"/>
<xsl:variable name="pattern-height" select="56"/>


<xsl:template match="skin">
<xsl:comment>CSS Generated by Injac genskin</xsl:comment>
body {
	font-family: arial, sans-serif;
	color: #000000;
	background-color: <xsl:value-of select="@bgcolor"/>;
}
       
    <xsl:apply-templates select="header"/>
    <xsl:apply-templates select="navbar"/>
    <xsl:apply-templates select="navpan"/>
    <xsl:apply-templates select="doc"/>
    <xsl:apply-templates select="tools"/>
</xsl:template>

<!-- STRUTURAL PROCESSING -->    
<!-- HEADER PROCESSING -->
<xsl:template match="header">
    <xsl:apply-templates select="header-title"/>
    <xsl:apply-templates select="logos"/>
    <xsl:apply-templates select="links"/>
    <xsl:apply-templates select="gensvg|framesvg"/>
</xsl:template>

<xsl:template match="header-title">
#header-title
{
position:absolute;
   top: <xsl:value-of select="@top"/>px;
<xsl:choose>
   <xsl:when test="@left &lt; 0">   
   right: <xsl:value-of select="-@left"/>px;
   </xsl:when>
   <xsl:otherwise>   
   left: <xsl:value-of select="@left"/>px;
   </xsl:otherwise>
</xsl:choose>
   width: <xsl:value-of select="gensvg/@width"/>px;
   height:<xsl:value-of select="gensvg/@height"/>px;
   background-image: url(../../gen/<xsl:value-of select="$skinname"/>/header-title.jpeg);
   z-index: 2;
}      
</xsl:template>

<xsl:template match="logos">
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="logo">
#<xsl:value-of select="@id"/>
{
	position:absolute;
	top:<xsl:value-of select="@top"/>px;
	left:<xsl:value-of select="@left"/>px;
}
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="links">
#<xsl:value-of select="name(..)"/>links{
   position:absolute;
   top:<xsl:value-of select="@top"/>px;
   left:<xsl:value-of select="@left"/>px;
}
A.<xsl:value-of select="name(..)"/>link:link,
A.<xsl:value-of select="name(..)"/>link:visited {<xsl:value-of select="@link-style"/>}
A.<xsl:value-of select="name(..)"/>link:hover,
A.<xsl:value-of select="name(..)"/>link:active {<xsl:value-of select="@active-style"/>}
A.<xsl:value-of select="name(..)"/>link { <xsl:value-of select="@link-style"/>}

.<xsl:value-of select="name(..)"/>link {
    <xsl:if test="gensvg">
	background-image: url(../../gen/skin-1N/<xsl:value-of select="name(..)"/>-links.jpeg);
    </xsl:if>
	<xsl:value-of select="@style"/>
	width: <xsl:value-of select="@width"/>px;
        height: <xsl:value-of select="@height"/>px;
}
    <xsl:apply-templates />
</xsl:template>

<xsl:template match="link">
    <xsl:apply-templates />
</xsl:template>


<!-- HEADER PROCESSING END-->

<!-- NAVBAR PROCESSING -->
<xsl:template match="navbar">
/* Barre de navigation */
#iNavBar
{
	position: absolute;
	top:<xsl:value-of select="@top"/>px;
        left:<xsl:value-of select="@left"/>px;
        width:<xsl:value-of select="@width"/>;
        height : <xsl:value-of select="@height"/>;
        background-image: url(../../gen/skin-1N/header.jpeg);
	background-color: #003366;
	color: #FFFFFF;
	font-family: arial, sans-serif;
	font-size: 12pt;
	z-index: 0;
	background-repeat: repeat-x;
}
#login{
	position:absolute;
   top:0px;
   right:2px;
	z-index: 1;
	height:25px;
	
}
#user{
	color: #FFFFFF;
	position:absolute;
   top:1px;
   right:105px;
	z-index: 1;
}
#iCurrentLoc
{
   position:absolute;
   top:3px;
   left:5%;
	color:#FFFFFF;
}
#iBackUri
{
   position:absolute;
   top:3px;
   left:350px;
}

</xsl:template>
<!-- NAVBAR PROCESSING END -->

<!-- NAVPAN PROCESSING -->
<xsl:template match="navpan">
#iNavPan
{
   position:absolute;
   top:<xsl:value-of select="@top"/>px;
   left:<xsl:value-of select="@left"/>px;
   width:<xsl:value-of select="@width"/>px;
   height : <xsl:value-of select="@height"/>px;
   text-align: <xsl:value-of select="@text-align"/>;
   overflow: auto;
   padding:0px;
   margin:-0px;
   z-index:<xsl:value-of select="@z-index"/>;
}

.ispace
{
   
   color: #0000FF;
	
}
.idoc
{
	font-family: arial, sans-serif; 
	font-size: 8pt; 
	color: #00A5FF;
}

.iseldoc
{
	font-family: arial, sans-serif;
	font-size: 8pt;
	color: Red;
}
A#iseldoc:link,
A#iseldoc:visited {
	COLOR: Silver;
	TEXT-DECORATION: none;
}
    <xsl:apply-templates select="navpan-title"/>
    <xsl:apply-templates select="links"/>
    <xsl:apply-templates select="gensvg|framesvg"/>
    
</xsl:template>

<xsl:template match="navpan-title">
#current-title {
   text-align: <xsl:value-of select="@text-align"/>;
   z-index: 3;
}
</xsl:template>

<!-- NAVPAN PROCESSING END -->

<!-- DOC PROCESSING -->
<xsl:template match="doc">
/* Panneau Document (centre) */
#iDocRender
{
   position:absolute;
   top:<xsl:value-of select="@top"/>px;
   left:<xsl:value-of select="@left"/>px;
   width:<xsl:value-of select="@width"/>px;

}
#iDocToPDF
{
   z-index:3;
   position:absolute;
   top:<xsl:value-of select="@top + 20"/>px;
   left:<xsl:value-of select="@top + @width"/>px;
   font-size: 8pt;
}
    <xsl:apply-templates select="doc-title"/>
    <xsl:apply-templates select="doc-element"/>
</xsl:template>

<xsl:template match="doc-title">
#doc-title
{
	font-family: garamond, arial, sans-serif; 
	font-size: 25pt; 
	font-weight: bold;
	color: black;
	background-image: url(../../gen/skin-1N/doc-title.jpeg);
	text-align: <xsl:value-of select="@text-align"/>;
        <xsl:if test="gensvg">
            <xsl:if test="gensvg/@x &gt;=0">
        width: <xsl:value-of select="gensvg/@width"/>px;
            </xsl:if>
        height: <xsl:value-of select="gensvg/@height"/>px;
        </xsl:if>
        
}
        <xsl:apply-templates select="gensvg"/>
</xsl:template>

<xsl:template match="doc-element">
.doc-element
{
	font-family: garamond, arial, sans-serif; 
	font-size: 12pt; 
	font-weight: bold;
	color: black;
	background-image: url(../../gen/skin-1N/doc-element.jpeg);
	text-align: <xsl:value-of select="@text-align"/>;
       <xsl:choose>
        <xsl:when test="gensvg">
        width: <xsl:value-of select="gensvg/@width"/>px;
        height: <xsl:value-of select="gensvg/@height"/>px;
        </xsl:when>
        <xsl:otherwise>
	height:22px;
        </xsl:otherwise>
       </xsl:choose>
}
        <xsl:apply-templates select="gensvg"/>
</xsl:template>
<!-- DOC PROCESSING END -->
<!-- TOOLS PROCESSING -->
<xsl:template match="tools">
#iTools
{
	z-index: 2;
	position: absolute;
	top:<xsl:value-of select="@top"/>px;
        left:<xsl:value-of select="@left"/>px;
	width:<xsl:value-of select="@width"/>px;
  
	
	overflow: auto;
	padding: 0px;
	margin: 0px;
	background-repeat: repeat-x;
}
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="tool">
    <xsl:if test="@type = 'lucene'">
#iTool<xsl:value-of select="@type"/>
{
    top:<xsl:value-of select="@top"/>px;
    left:<xsl:value-of select="@left"/>px;
}
    
    
#<xsl:value-of select="@type"/>tool-title {
    top:<xsl:value-of select="../@top"/>px;
    left:<xsl:value-of select="../@left"/>px;
    text-align: <xsl:value-of select="@text-align"/>;
}    

#search-result-tab{
	
	font-size: 10pt;
	border-width: 2px; 
	border-color : #E6E6FA;
}

    </xsl:if>        
</xsl:template>
<!-- TOOLS PROCESSING END-->
<!-- GENERIC PROCESSING -->

<xsl:template match="gensvg">
<xsl:variable name="parent" select="name(..)"/>
.gen<xsl:value-of select="$parent"/> {
       width: <xsl:value-of select="@width"/>px;
        height: <xsl:value-of select="@height"/>px;
	font-family: garamond, arial, sans-serif; 
	font-size: 14pt; 
	font-weight: bold;
	color: black;
	background-image: url(../../gen/skin-1N/navpan.jpeg);
}

</xsl:template>

<xsl:template match="framesvg">
<xsl:variable name="parent" select="name(..)"/>
<xsl:variable name="mwidth">
    <xsl:choose>
        <xsl:when test="@width='full'">98%</xsl:when>
        <xsl:otherwise><xsl:value-of select="@width - ($tile-width)"/>px</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="rightx">
    <xsl:choose>
        <xsl:when test="@width='full'">right:0px</xsl:when>
        <xsl:otherwise>left:<xsl:value-of select="@width - $tile-width"/>px</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="mheight">
    <xsl:choose>
        <xsl:when test="@height='full'">98%</xsl:when>
        <xsl:otherwise><xsl:value-of select="@height - ($tile-height * 2)"/>px</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="bottomy">
    <xsl:choose>
        <xsl:when test="@height='full'">bottom:0px</xsl:when>
        <xsl:otherwise>top:<xsl:value-of select="@top + @height - $tile-height"/>px</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
.<xsl:value-of select="$parent"/>Tile{
	z-index:<xsl:value-of select="@z-index"/>;
        width: <xsl:value-of select="$tile-width"/>px;
        height: <xsl:value-of select="$tile-height"/>px;
}

#<xsl:value-of select="$parent"/>Frame{
}
   
#<xsl:value-of select="$parent"/>LT{
        position:absolute;	
        top:<xsl:value-of select="@top"/>px;
        left:<xsl:value-of select="@left"/>px;
         width: <xsl:value-of select="$tile-width"/>px;
        height: <xsl:value-of select="$tile-height"/>px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/LT.jpeg);
}
#<xsl:value-of select="$parent"/>MT{
        position:absolute;	
        top:<xsl:value-of select="@top"/>px;
        left:<xsl:value-of select="@left + $tile-width"/>px;
	width: <xsl:value-of select="$mwidth"/>;
        height: <xsl:value-of select="$tile-height"/>px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/MT.jpeg);
	
}
#<xsl:value-of select="$parent"/>RT{
        position:absolute;	
        top:<xsl:value-of select="@top"/>px;
        <xsl:value-of select="$rightx"/>;
        width: <xsl:value-of select="$tile-width"/>px;
        height: <xsl:value-of select="$tile-height"/>px;
        background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/RT.jpeg);
}
#<xsl:value-of select="$parent"/>ML{
position:absolute;	
        top:<xsl:value-of select="@top + 15"/>px;
        left:<xsl:value-of select="@left"/>px;
	width: <xsl:value-of select="$tile-width"/>px;
        height:<xsl:value-of select="$mheight"/>;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/ML.jpeg);
}
#<xsl:value-of select="$parent"/>MM{
position:absolute;	
        top:<xsl:value-of select="@top + 15"/>px;
        left:<xsl:value-of select="@left+10"/>px;
	width: <xsl:value-of select="$mwidth"/>;
	height:<xsl:value-of select="$mheight"/>;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/MM.jpeg);
}
#<xsl:value-of select="$parent"/>MR{
position:absolute;	
        top:<xsl:value-of select="@top + 15"/>px;
        <xsl:value-of select="$rightx"/>;
        width: <xsl:value-of select="$tile-width"/>px;
        height:<xsl:value-of select="$mheight"/>;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/MR.jpeg);
}
#<xsl:value-of select="$parent"/>LB{
position:absolute;	
        <xsl:value-of select="$bottomy"/>;
        left: <xsl:value-of select="@left"/>px;
         width: <xsl:value-of select="$tile-width"/>px;
        height: <xsl:value-of select="$tile-height"/>px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/LB.jpeg);
}
#<xsl:value-of select="$parent"/>MB{
	position: absolute;
	<xsl:value-of select="$bottomy"/>;
	left: <xsl:value-of select="@left+10"/>px;
	width: <xsl:value-of select="$mwidth"/>;
        height: <xsl:value-of select="$tile-height"/>px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/MB.jpeg);
	background-repeat: repeat-x;
}
#<xsl:value-of select="$parent"/>RB{
position:absolute;	
        <xsl:value-of select="$bottomy"/>;
        <xsl:value-of select="$rightx"/>;
        width: <xsl:value-of select="$tile-width"/>px;
        height: <xsl:value-of select="$tile-height"/>px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/<xsl:value-of select="$parent"/>/RB.jpeg);
}

</xsl:template>


<!--xsl:template match="header/framesvg">
<xsl:variable name="parent" select="name(..)"/>
<xsl:variable name="mwidth">
    <xsl:choose>
        <xsl:when test="@width='full'">99%</xsl:when>
        <xsl:otherwise><xsl:value-of select="@width -15"/>px</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="rightx">
    <xsl:choose>
        <xsl:when test="@width='full'">right:0px;</xsl:when>
        <xsl:otherwise>left:<xsl:value-of select="@width -15"/>px;</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="mheight">
    <xsl:choose>
        <xsl:when test="@height='full'">99%</xsl:when>
        <xsl:otherwise><xsl:value-of select="@height - 15"/>px</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
<xsl:variable name="bottomy">
    <xsl:choose>
        <xsl:when test="@height='full'">bottom:0px;</xsl:when>
        <xsl:otherwise>top:<xsl:value-of select="@top + @height"/>px;</xsl:otherwise>
    </xsl:choose>
</xsl:variable>
.<xsl:value-of select="$parent"/>Tile{
	z-index:<xsl:value-of select="@z-index"/>;
}
   
#<xsl:value-of select="$parent"/>LT{
        position:absolute;	
        top:<xsl:value-of select="@top"/>px;
        left:<xsl:value-of select="@left"/>px;
	width:15px;
	height:15px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/LT.jpeg);
}
#<xsl:value-of select="$parent"/>MT{
	position: absolute;
        top:<xsl:value-of select="@top"/>px;
        left:<xsl:value-of select="@left+10"/>px;
	width: <xsl:value-of select="$mwidth"/>;
	height: 15px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/MT.jpeg);
	background-repeat: repeat-x;
}
#<xsl:value-of select="$parent"/>RT{
position:absolute;	
        top:<xsl:value-of select="@top"/>px;
        <xsl:value-of select="$rightx"/>
	width:15px;
	height:15px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/RT.jpeg);
}
#<xsl:value-of select="$parent"/>ML{
position:absolute;	
        top:<xsl:value-of select="@top + 15"/>px;
        left:<xsl:value-of select="@left"/>px;
	width:15px;
	height:<xsl:value-of select="$mheight"/>;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/ML.jpeg);
}
#<xsl:value-of select="$parent"/>MM{
position:absolute;	
        top:<xsl:value-of select="@top + 15"/>px;
        left:<xsl:value-of select="@left+10"/>px;
	width: <xsl:value-of select="$mwidth"/>;
	height:<xsl:value-of select="$mheight"/>;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/MM.jpeg);
}
#<xsl:value-of select="$parent"/>MR{
position:absolute;	
        top:<xsl:value-of select="@top + 15"/>px;
        <xsl:value-of select="$rightx"/>
	width:15px;
	height:<xsl:value-of select="$mheight"/>;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/MR.jpeg);
}
#<xsl:value-of select="$parent"/>LB{
position:absolute;	
        <xsl:value-of select="$bottomy"/>
        left:<xsl:value-of select="@left"/>px;
	width:15px;
	height:14px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/LB.jpeg);
}
#<xsl:value-of select="$parent"/>MB{
	position: absolute;
	<xsl:value-of select="$bottomy"/>
	left: <xsl:value-of select="@left+10"/>px;
	width: <xsl:value-of select="$mwidth"/>;
	height: 14px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/MB.jpeg);
	background-repeat: repeat-x;
}
#<xsl:value-of select="$parent"/>RB{
position:absolute;	
        <xsl:value-of select="$bottomy"/>
        <xsl:value-of select="$rightx"/>
	width:15px;
	height:14px;
	background-image: url(../../frame/<xsl:value-of select="$skinname"/>/header/RB.jpeg);
}

</xsl:template-->


</xsl:stylesheet>